<?php
/* --------------------------------------------------------------
   WithdrawalId.php 2020-01-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Models;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalId as WithdrawalIdInterface;
use InvalidArgumentException;
use Webmozart\Assert\Assert;

/**
 * Class WithdrawalId
 *
 * @package Gambio\Admin\Withdrawal\Models
 */
class WithdrawalId implements WithdrawalIdInterface
{
    /**
     * @var int|null
     */
    private $value;
    
    
    /**
     * WithdrawalId constructor.
     *
     * @param int|null $value
     */
    private function __construct(?int $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * Creates a new WithdrawalId instance.
     *
     * @param int|null $value
     *
     * @return WithdrawalId
     *
     * @throws InvalidArgumentException
     */
    public static function create(?int $value = null): WithdrawalId
    {
        if ($value !== null) {
            Assert::greaterThan($value, 0, 'The withdrawal ID must be a positive integer or null. Got: %s');
        }
        
        return new self($value);
    }
    
    
    /**
     * Returns the value of this ID.
     *
     * @return int|null
     */
    public function value(): ?int
    {
        return $this->value;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize()
    {
        return $this->value;
    }
}